/***************************************************************************************************
 * Copyright (c) 2017-2018, NVIDIA CORPORATION.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted
 * provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright notice, this list of
 *       conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright notice, this list of
 *       conditions and the following disclaimer in the documentation and/or other materials
 *       provided with the distribution.
 *     * Neither the name of the NVIDIA CORPORATION nor the names of its contributors may be used
 *       to endorse or promote products derived from this software without specific prior written
 *       permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL NVIDIA CORPORATION BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TOR (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 **************************************************************************************************/
#include "cutlass_unit_test.h"
#include "cutlass/gemm/gemm.h"
#include "cutlass/gemm/fp16_sgemm_traits.h"
#include "tools/test/unit/gemm/gemm_testbed.h"
#include "tools/test/unit/gemm/run_gemm.h"

#if !defined(__CUDA_ARCH__) || __CUDA_ARCH__ >= 530


TEST(Fp16_sgemm_alphaFp32_fp32_128x128x16, fp16_sgemm_fp32_128x128x16_nn) {
  /*A, B are half typed, accumulator is always float for sgemm, C, D are float typed
  alpha and beta are both fp32*/
  typedef cutlass::gemm::Fp16SgemmSgemmTraits<cutlass::MatrixLayout::kColumnMajor,
    cutlass::MatrixLayout::kColumnMajor,
    cutlass::Shape<16, 128, 128>,
    half, /*A type*/
    half, /*B type*/
    float, /*C type*/
    float, /*D type*/
    float /*alpha, beta type*/
  >
    SgemmTraits;
  run_gemm<SgemmTraits>(128, 128, 16);
}

////////////////////////////////////////////////////////////////////////////////////////////////////

TEST(Fp16_sgemm_alphaFp32_fp32_128x128x16, fp16_sgemm_fp32_128x128x16_nt) {
  /*A, B are half typed, accumulator is always float for sgemm, C, D are float typed
  alpha and beta are both fp32*/
  typedef cutlass::gemm::Fp16SgemmSgemmTraits<cutlass::MatrixLayout::kColumnMajor,
    cutlass::MatrixLayout::kRowMajor,
    cutlass::Shape<16, 128, 128>,
    half, /*A type*/
    half, /*B type*/
    float, /*C type*/
    float, /*D type*/
    float /*alpha, beta type*/
  >
    SgemmTraits;
  run_gemm<SgemmTraits>(128, 128, 16);
}

////////////////////////////////////////////////////////////////////////////////////////////////////

TEST(Fp16_sgemm_alphaFp32_fp32_128x128x16, fp16_sgemm_fp32_128x128x16_tn) {
  /*A, B are half typed, accumulator is always float for sgemm, C, D are float typed
  alpha and beta are both fp32*/
  typedef cutlass::gemm::Fp16SgemmSgemmTraits<cutlass::MatrixLayout::kRowMajor,
    cutlass::MatrixLayout::kColumnMajor,
    cutlass::Shape<16, 128, 128>,
    half, /*A type*/
    half, /*B type*/
    float, /*C type*/
    float, /*D type*/
    float /*alpha, beta type*/
  >
    SgemmTraits;
  run_gemm<SgemmTraits>(128, 128, 16);
}

////////////////////////////////////////////////////////////////////////////////////////////////////

TEST(Fp16_sgemm_alphaFp32_fp32_128x128x16, fp16_sgemm_fp32_128x128x16_tt) {
  /*A, B are half typed, accumulator is always float for sgemm, C, D are float typed
  alpha and beta are both fp32*/
  typedef cutlass::gemm::Fp16SgemmSgemmTraits<cutlass::MatrixLayout::kRowMajor,
    cutlass::MatrixLayout::kRowMajor,
    cutlass::Shape<16, 128, 128>,
    half, /*A type*/
    half, /*B type*/
    float, /*C type*/
    float, /*D type*/
    float /*alpha, beta type*/
  >
    SgemmTraits;
  run_gemm<SgemmTraits>(128, 128, 16);
}

////////////////////////////////////////////////////////////////////////////////////////////////////

TEST(Fp16_sgemm_alphaFp32_fp32_128x128x16, fp16_sgemm_fp32_128x112x17_nn) {
  /*A, B are half typed, accumulator is always float for sgemm, C, D are float typed
  alpha and beta are both fp32*/
  typedef cutlass::gemm::Fp16SgemmSgemmTraits<cutlass::MatrixLayout::kColumnMajor,
    cutlass::MatrixLayout::kRowMajor,
    cutlass::Shape<16, 128, 128>,
    half, /*A type*/
    half, /*B type*/
    float, /*C type*/
    float, /*D type*/
    float /*alpha, beta type*/
  >
    SgemmTraits;
  run_gemm<SgemmTraits>(128, 112, 17);
}

////////////////////////////////////////////////////////////////////////////////////////////////////

TEST(Fp16_sgemm_alphaFp32_fp32_128x128x16, fp16_sgemm_fp32_128x112x17_nt) {
  /*A, B are half typed, accumulator is always float for sgemm, C, D are float typed
  alpha and beta are both fp32*/
  typedef cutlass::gemm::Fp16SgemmSgemmTraits<cutlass::MatrixLayout::kRowMajor,
    cutlass::MatrixLayout::kColumnMajor,
    cutlass::Shape<16, 128, 128>,
    half, /*A type*/
    half, /*B type*/
    float, /*C type*/
    float, /*D type*/
    float /*alpha, beta type*/
  >
    SgemmTraits;
  run_gemm<SgemmTraits>(128, 112, 17);
}

////////////////////////////////////////////////////////////////////////////////////////////////////

TEST(Fp16_sgemm_alphaFp32_fp32_128x128x16, fp16_sgemm_fp32_128x112x17_tn) {
  /*A, B are half typed, accumulator is always float for sgemm, C, D are float typed
  alpha and beta are both fp32*/
  typedef cutlass::gemm::Fp16SgemmSgemmTraits<cutlass::MatrixLayout::kRowMajor,
    cutlass::MatrixLayout::kRowMajor,
    cutlass::Shape<16, 128, 128>,
    half, /*A type*/
    half, /*B type*/
    float, /*C type*/
    float, /*D type*/
    float /*alpha, beta type*/
  >
    SgemmTraits;
  run_gemm<SgemmTraits>(128, 112, 17);
}

////////////////////////////////////////////////////////////////////////////////////////////////////

TEST(Fp16_sgemm_alphaFp32_fp32_128x128x16, fp16_sgemm_fp32_128x112x17_tt) {
  /*A, B are half typed, accumulator is always float for sgemm, C, D are float typed
  alpha and beta are both fp32*/
  typedef cutlass::gemm::Fp16SgemmSgemmTraits<cutlass::MatrixLayout::kColumnMajor,
    cutlass::MatrixLayout::kColumnMajor,
    cutlass::Shape<16, 128, 128>,
    half, /*A type*/
    half, /*B type*/
    float, /*C type*/
    float, /*D type*/
    float /*alpha, beta type*/
  >
    SgemmTraits;
  run_gemm<SgemmTraits>(128, 112, 17);
}

#endif

